<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}

include('includes/header.php');

// Fetch DNS list
$dnsList = $db->select('dns', '*', '', 'id ASC');

// Fetch playlists to compute counts
$allPlaylists = $db->select('playlist', '*', '', '');

$now = time();
$since7 = $now - (7 * 24 * 60 * 60);

$perDnsTotals = [];
$perDnsNew7 = [];
$totalClients = 0;
$totalNew7 = 0;

foreach ($dnsList as $d) {
    $perDnsTotals[$d['id']] = 0;
    $perDnsNew7[$d['id']] = 0;
}

foreach ($allPlaylists as $p) {
    $dnsId = isset($p['dns_id']) ? (int)$p['dns_id'] : 0;
    if (!isset($perDnsTotals[$dnsId])) $perDnsTotals[$dnsId] = 0;
    if (!isset($perDnsNew7[$dnsId])) $perDnsNew7[$dnsId] = 0;
    $perDnsTotals[$dnsId]++;
    $totalClients++;
    $created = isset($p['created_at']) ? (int)$p['created_at'] : 0;
    if ($created > 0 && $created >= $since7) {
        $perDnsNew7[$dnsId]++;
        $totalNew7++;
    }
}

$dnsCount = count($dnsList);
?>

<div class="container-fluid">
  <div class="row">
    <div class="col-md-4 mb-3">
      <div class="card">
        <div class="card-header"><strong>Total Clients</strong></div>
        <div class="card-body">
          <h3 class="mb-0 text-orange"><?php echo $totalClients; ?></h3>
          <small class="text-muted">All DNS combined</small>
        </div>
      </div>
    </div>
    <div class="col-md-4 mb-3">
      <div class="card">
        <div class="card-header"><strong>New (last 7 days)</strong></div>
        <div class="card-body">
          <h3 class="mb-0 text-orange"><?php echo $totalNew7; ?></h3>
          <small class="text-muted">Since <?php echo date('Y-m-d', $since7); ?></small>
        </div>
      </div>
    </div>
    <div class="col-md-4 mb-3">
      <div class="card">
        <div class="card-header"><strong>Total DNS</strong></div>
        <div class="card-body">
          <h3 class="mb-0 text-orange"><?php echo $dnsCount; ?></h3>
          <small class="text-muted">Configured portals</small>
        </div>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-md-8 mb-4">
      <div class="card">
        <div class="card-header"><strong>Clients per DNS (total)</strong></div>
        <div class="card-body">
          <canvas id="chartTotals" height="120"></canvas>
        </div>
      </div>
    </div>
    <div class="col-md-4 mb-4">
      <div class="card">
        <div class="card-header"><strong>New in 7 days per DNS</strong></div>
        <div class="card-body">
          <canvas id="chartNew7" height="120"></canvas>
        </div>
      </div>
    </div>
  </div>

  <div class="row">
    <div class="col-12 mb-4">
      <div class="card">
        <div class="card-header"><strong>Breakdown</strong></div>
        <div class="card-body">
          <div class="table-responsive">
            <table class="table table-striped table-hover table-sm">
              <thead>
                <tr>
                  <th>#</th>
                  <th>DNS</th>
                  <th>URL</th>
                  <th class="text-right">Total Clients</th>
                  <th class="text-right">New (7d)</th>
                </tr>
              </thead>
              <tbody>
              <?php $i=1; foreach ($dnsList as $d): ?>
                <tr>
                  <td><?php echo $i++; ?></td>
                  <td><?php echo htmlspecialchars($d['title']); ?></td>
                  <td><a href="<?php echo htmlspecialchars($d['url']); ?>" target="_blank"><?php echo htmlspecialchars($d['url']); ?></a></td>
                  <td class="text-right"><?php echo $perDnsTotals[$d['id']] ?? 0; ?></td>
                  <td class="text-right"><?php echo $perDnsNew7[$d['id']] ?? 0; ?></td>
                </tr>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
(function(){
  const labels = <?php echo json_encode(array_map(fn($d)=>$d['title'], $dnsList)); ?>;
  const totals = <?php echo json_encode(array_values(array_map(fn($d)=>($perDnsTotals[$d['id']] ?? 0), $dnsList))); ?>;
  const new7 = <?php echo json_encode(array_values(array_map(fn($d)=>($perDnsNew7[$d['id']] ?? 0), $dnsList))); ?>;

  const baseColor = 'rgba(255,106,0,0.8)';
  const baseBg = 'rgba(255,106,0,0.25)';

  const ctx1 = document.getElementById('chartTotals');
  if (ctx1) {
    new Chart(ctx1, {
      type: 'bar',
      data: {
        labels,
        datasets: [{
          label: 'Total Clients',
          data: totals,
          borderColor: baseColor,
          backgroundColor: baseBg,
          borderWidth: 2,
        }]
      },
      options: {
        responsive: true,
        plugins: { legend: { display: false } },
        scales: {
          x: { ticks: { color: '#e9eaee' }, grid: { color: 'rgba(255,255,255,0.08)' } },
          y: { ticks: { color: '#e9eaee' }, grid: { color: 'rgba(255,255,255,0.08)' }, beginAtZero: true }
        }
      }
    });
  }

  const ctx2 = document.getElementById('chartNew7');
  if (ctx2) {
    new Chart(ctx2, {
      type: 'bar',
      data: {
        labels,
        datasets: [{
          label: 'New (7d)',
          data: new7,
          borderColor: baseColor,
          backgroundColor: baseBg,
          borderWidth: 2,
        }]
      },
      options: {
        responsive: true,
        plugins: { legend: { display: false } },
        scales: {
          x: { ticks: { color: '#e9eaee' }, grid: { color: 'rgba(255,255,255,0.08)' } },
          y: { ticks: { color: '#e9eaee' }, grid: { color: 'rgba(255,255,255,0.08)' }, beginAtZero: true }
        }
      }
    });
  }
})();
</script>

<?php include('includes/footer.php'); ?>
</body>
</html>
