<?php
ini_set('display_errors', 1);
if(session_status() === PHP_SESSION_NONE) session_start();
include(__DIR__ . '/functions.php');

$log_check = $db->select('users', '*', 'id = :id', '', [':id' => 1]);
$loggedinuser = !empty($log_check) ? $log_check[0]['username'] : null;
if (empty($loggedinuser) && isset($_SESSION['name']) && $_SESSION['name'] === $loggedinuser) {
	header("Location: index.php");
	exit;
}
// Fetch UI settings (favicon and logos)
$ui = $db->select('settings', '*', 'id = :id', '', [':id' => 1]);
$ui = !empty($ui) ? $ui[0] : [];
$favicon = !empty($ui['favicon_path']) ? $ui['favicon_path'] : 'img/logo.png';
$sidebarLogo = !empty($ui['sidebar_logo_path']) ? $ui['sidebar_logo_path'] : '';
$currentPage = basename($_SERVER['SCRIPT_NAME']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="author" content="J2-DEV's">
	<link rel="icon" href="<?=$favicon?>" type="image/png">
	<link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.1.3/css/bootstrap.min.css" integrity="sha384-MCw98/SFnGE8fJT3GXwEOngsV7Zt27NXFoaoApmYm81iuXoPkFOJwJ8ERdknLPMO" crossorigin="anonymous">
	<link href="css/themes/darkly/bootstrap.css" rel="stylesheet" title="main">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.2.3/animate.min.css">
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
	<link href="css/simple-sidebar.css" rel="stylesheet">
	<link href="css/theme.css" rel="stylesheet">
</head>
<body>
<style>
body{
  background-color: #0f1722;
  color: #fff;
}

#pageMessages {
  left: 50%;
  transform: translateX(-50%);
  position:fixed; 
  text-align: center;
  top: 5px;
  width: 60%;
  z-index:9999; 
  border-radius:0px
}

.alert {
  position: relative;
}

.alert .close {
  position: absolute;
  top: 5px;
  right: 5px;
  font-size: 1em;
}

.alert .fa {
  margin-right:.3em;
}
</style>

  <div class="d-flex" id="wrapper">
	<!-- Sidebar-->
	<div class="" id="sidebar-wrapper">
	  <div class="sidebar-heading">
	    <?php if(!empty($sidebarLogo)): ?>
	      <img src="<?=$sidebarLogo?>" alt="Logo" style="max-width:160px; max-height:60px;">
	    <?php else: ?>
	      J2-DEV's Panel
	    <?php endif; ?>
	  </div>
	  <span class="list-grup-item">&nbsp;&nbsp;&nbsp;&nbsp;© <?=date("Y")?> • J2-DEV's</span></center>
<div class="list-group list-group-flush">
    <a class="list-group-item list-group-item-action <?= $currentPage==='dashboard.php' ? 'active' : '' ?>" href="dashboard.php">
        <i class="fa fa-tachometer"></i>&nbsp;&nbsp; Dashboard
    </a>
    <a class="list-group-item list-group-item-action <?= $currentPage==='dns.php' ? 'active' : '' ?>" href="dns.php">
        <i class="fa fa-cogs"></i>&nbsp;&nbsp; DNS Settings
    </a>
    <a class="list-group-item list-group-item-action <?= $currentPage==='actusers.php' ? 'active' : '' ?>" href="actusers.php">
        <i class="fa fa-users"></i>&nbsp;&nbsp; End Users
    </a>
    <a class="list-group-item list-group-item-action <?= $currentPage==='apk_manage.php' ? 'active' : '' ?>" href="apk_manage.php">
        <i class="fa fa-android"></i>&nbsp;&nbsp; APP Update
    </a>
    <a class="list-group-item list-group-item-action <?= $currentPage==='user.php' ? 'active' : '' ?>" href="user.php">
        <i class="fa fa-user"></i>&nbsp;&nbsp; Update Credentials
    </a>
    <a class="list-group-item list-group-item-action <?= $currentPage==='settings.php' ? 'active' : '' ?>" href="settings.php">
        <i class="fa fa-wrench"></i>&nbsp;&nbsp; Settings
    </a>
</div>

	</div>
	<!-- /#sidebar-wrapper -->

	<!-- Page Content -->
	<div id="page-content-wrapper">

	  <nav class="navbar navbar-expand-lg navbar-dark ">

		<button class="btn btn-primary" id="menu-toggle"><img src="img/logo.png" width="25" height="25" class="d-flex justify-content-center text-allign centre" alt=""></button>
		
	  &nbsp;&nbsp;
		<div class="center" id="pageMessages"></div>
		<a href="logout.php" class="btn btn-danger ml-auto mr-1">Logout</a>
	  </nav>

	  <div class="container-fluid"><br>
