<?php
session_start();

if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
    header('Location: index.php');
    exit;
}

include ('includes/header.php');

$table_name = 'settings';

$data = ['tmdb_key' => '', 'favicon_path' => '', 'login_bg_path' => '', 'login_logo_path' => '', 'sidebar_logo_path' => ''];
$db->insertIfEmpty($table_name, $data);

$res = $db->select($table_name, '*', '', '');

// Handle uploads
if(isset($_POST['submit'])){
    unset($_POST['submit']);
    $updateData = $_POST;

    // Prepare upload directory
    $uploadDir = 'img/uploads';
    if (!is_dir($uploadDir)) {
        @mkdir($uploadDir, 0755, true);
    }

    function save_uploaded_if_present($key, $allowed, $uploadDir) {
        if (!isset($_FILES[$key]) || empty($_FILES[$key]['name'])) return null;
        if ($_FILES[$key]['error'] !== UPLOAD_ERR_OK) return null;
        $ext = strtolower(pathinfo($_FILES[$key]['name'], PATHINFO_EXTENSION));
        if (!in_array($ext, $allowed)) return null;
        $base = preg_replace('/[^a-z0-9_-]/i','_', pathinfo($_FILES[$key]['name'], PATHINFO_FILENAME));
        $fname = $base.'_'.time().'.'.$ext;
        $target = rtrim($uploadDir,'/').'/'.$fname;
        if (move_uploaded_file($_FILES[$key]['tmp_name'], $target)) {
            return $target;
        }
        return null;
    }

    // Save files
    $faviconPath = save_uploaded_if_present('favicon', ['png','jpg','jpeg','ico','webp'], $uploadDir);
    $loginBgPath = save_uploaded_if_present('login_bg', ['png','jpg','jpeg','webp'], $uploadDir);
    $loginLogoPath = save_uploaded_if_present('login_logo', ['png','jpg','jpeg','webp','svg'], $uploadDir);
    $sidebarLogoPath = save_uploaded_if_present('sidebar_logo', ['png','jpg','jpeg','webp','svg'], $uploadDir);

    if ($faviconPath) { $updateData['favicon_path'] = $faviconPath; }
    if ($loginBgPath) { $updateData['login_bg_path'] = $loginBgPath; }
    if ($loginLogoPath) { $updateData['login_logo_path'] = $loginLogoPath; }
    if ($sidebarLogoPath) { $updateData['sidebar_logo_path'] = $sidebarLogoPath; }

    $db->update($table_name, $updateData, 'id = :id',[':id' => 1]);
    echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}

?>

        <div class="col-md-10 mx-auto">
            <div class="card-body">
                <div class="card text-white">
                    <div class="card-header">
                        <center>
                            <h2 class="text-orange"><i class="fa fa-wrench"></i> Configurações do Painel</h2>
                        </center>
                    </div>
                    <div class="card-body">
                            <form method="post" enctype="multipart/form-data">
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label class="form-label">Tmdb API KEY</label>
                                        <input class="form-control" name="tmdb_key" value="<?=$res[0]['tmdb_key'] ?>" type="text"/>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Favicon</label>
                                        <input type="file" class="form-control" name="favicon" accept=".png,.jpg,.jpeg,.ico,.webp">
                                        <?php if(!empty($res[0]['favicon_path'])): ?>
                                            <small class="text-muted">Atual: <?=$res[0]['favicon_path']?></small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Logo da Sidebar</label>
                                        <input type="file" class="form-control" name="sidebar_logo" accept=".png,.jpg,.jpeg,.webp,.svg">
                                        <?php if(!empty($res[0]['sidebar_logo_path'])): ?>
                                            <small class="text-muted">Atual: <?=$res[0]['sidebar_logo_path']?></small>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Logo da Tela de Login</label>
                                        <input type="file" class="form-control" name="login_logo" accept=".png,.jpg,.jpeg,.webp,.svg">
                                        <?php if(!empty($res[0]['login_logo_path'])): ?>
                                            <small class="text-muted">Atual: <?=$res[0]['login_logo_path']?></small>
                                        <?php endif; ?>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Fundo da Tela de Login</label>
                                        <input type="file" class="form-control" name="login_bg" accept=".png,.jpg,.jpeg,.webp">
                                        <?php if(!empty($res[0]['login_bg_path'])): ?>
                                            <small class="text-muted">Atual: <?=$res[0]['login_bg_path']?></small>
                                        <?php endif; ?>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <center>
                                        <button class="btn btn-primary" name="submit" type="submit">
                                            <i class="fa fa-check"></i> Salvar
                                        </button>
                                    </center>
                                </div>
                            </form>
                    </div>
                </div>
            </div>
        </div>

<?php include ('includes/footer.php');?>